/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jclass.bwt.JCSerializable;
import jclass.chart.BarPoint;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartDraw;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.MinMax;

class BarChartDraw
extends ChartDraw
implements JCSerializable {
    public static final int SIDE_0 = 1;
    public static final int SIDE_1 = 2;
    public static final int SIDE_2 = 4;
    public static final int SIDE_3 = 8;
    public static final int OUTLINE_SENSITIVITY = 3;
    transient BarPoint[][] pts;
    double bar_base;
    int top;
    int bottom;
    int left;
    int right;
    boolean is_3d = false;
    boolean drawOutline = true;
    Rectangle r;
    boolean inverted = false;
    Point start;
    Point end;

    public BarChartDraw(ChartDataView dataObject) {
        super(dataObject);
    }

    public void recalc() {
        boolean x_reversed;
        super.recalc();
        JCBarChartFormat format = this.dataObject.barChartFormat;
        if (format == null || format.clusterWidth == 0) {
            return;
        }
        int delta_x = this.chartArea.deltaX;
        int delta_y = this.chartArea.deltaY;
        boolean bl = this.is_3d = delta_x != 0 || delta_y != 0;
        if (this.is_3d && format.clusterOverlap > 0) {
            format.clusterOverlap = 0;
        }
        MinMax x = new MinMax();
        MinMax y = new MinMax();
        this.dataObject.getDataBounds(x, y);
        double gapf = 1.0 - (double)format.clusterOverlap / 100.0;
        double barf = this.numActiveDataSeries;
        barf = (barf - 1.0) * gapf + 1.0;
        this.bar_base = this.dataObject.xaxis.step * (double)format.clusterWidth / (barf * 100.0);
        double csize2 = barf * this.bar_base / 2.0;
        double binc = gapf * this.bar_base;
        boolean inverted = this.dataObject.xaxis.isVertical;
        x.min -= csize2;
        x.max += csize2;
        this.dataObject.xaxis.setLimits(x);
        this.dataObject.xaxis.calcTransformation();
        this.dataObject.xaxis.layoutAnnotations();
        this.dataObject.xaxis.checkAnnotations();
        y.min = JCChartUtil.min(this.dataObject.yaxis.origin.value, y.min);
        y.max = JCChartUtil.max(this.dataObject.yaxis.origin.value, y.max);
        this.dataObject.yaxis.setLimits(y);
        this.dataObject.yaxis.calcTransformation();
        x = this.dataObject.xaxis.dataLimits;
        y = this.dataObject.yaxis.dataLimits;
        this.drawOutline = Math.abs(this.dataObject.xaxis.toPixel(this.dataObject.xaxis.min.value + this.bar_base) - this.dataObject.xaxis.toPixel(this.dataObject.xaxis.min.value)) > 3;
        int width = inverted ? this.dataObject.yaxis.getWidth() : this.dataObject.xaxis.getHeight();
        int height = inverted ? this.dataObject.xaxis.getWidth() : this.dataObject.yaxis.getHeight();
        this.left = inverted ? this.dataObject.yaxis.getLeft() : this.dataObject.xaxis.getLeft();
        this.right = this.left + width - 1;
        this.top = inverted ? this.dataObject.xaxis.getTop() : this.dataObject.yaxis.getTop();
        this.bottom = this.top + height - 1;
        Point firstLast = this.dataObject.getFirstLast();
        if (firstLast == null) {
            return;
        }
        int nseries = this.dataObject.getSeries().length;
        int nvisseries = this.dataObject.getVisibleDataSeries();
        this.pts = new BarPoint[firstLast.y - firstLast.x + 1][nseries];
        int pix_org = this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value);
        boolean bl2 = x_reversed = this.dataObject.xaxis.isReversed;
        boolean switch_order = inverted ? (delta_y > 0 ? true ^ x_reversed : x_reversed) : (delta_x <= 0 ? true ^ x_reversed : x_reversed);
        boolean firstBar = true;
        ChartDataViewSeries[] series = this.dataObject.getSeries();
        int i = firstLast.x;
        while (i <= firstLast.y) {
            int position = i - firstLast.x;
            int bar_num = 0;
            int j = 0;
            while (j < series.length) {
                if (series[j].isShowing) {
                    double sx = series[j].getX(i);
                    double base = series[j].getX(i) - csize2;
                    double xbeg_value = base + (double)bar_num * binc;
                    double xend_value = xbeg_value + this.bar_base;
                    ++bar_num;
                    if (!(xbeg_value < this.dataObject.xaxis.min.value && xend_value < this.dataObject.xaxis.min.value || xbeg_value > this.dataObject.xaxis.max.value && xend_value > this.dataObject.xaxis.max.value)) {
                        int bar_width;
                        int bar_height;
                        int pix_y;
                        int pix_x;
                        double yvalue;
                        this.pts[position][j] = new BarPoint();
                        this.pts[position][j].x = xbeg_value;
                        if (xend_value <= x.min || xbeg_value >= x.max) {
                            this.pts[position][j].x = this.dataObject.holeValue;
                        }
                        this.pts[position][j].y = (yvalue = series[j].getY(i)) == this.dataObject.holeValue ? this.dataObject.holeValue : (yvalue = JCChartUtil.clamp(yvalue, y.min, y.max));
                        BarPoint bp = this.pts[position][j];
                        bp.front = null;
                        bp.top = null;
                        bp.side = null;
                        if (inverted) {
                            pix_x = this.dataObject.yaxis.toPixel(bp.y);
                            pix_y = this.dataObject.xaxis.toPixel(bp.x);
                            bar_height = pix_y - this.dataObject.xaxis.toPixel(bp.x + this.bar_base);
                            bar_width = pix_x - pix_org;
                        } else {
                            pix_x = this.dataObject.xaxis.toPixel(bp.x);
                            pix_y = this.dataObject.yaxis.toPixel(bp.y);
                            bar_width = this.dataObject.xaxis.toPixel(bp.x + this.bar_base) - pix_x;
                            bar_height = pix_org - pix_y;
                        }
                        if (this.is_3d && bp.x != this.dataObject.holeValue && bp.y != this.dataObject.holeValue) {
                            Point[] top_points = new Point[4];
                            Point[] side_points = new Point[4];
                            top_points[0] = new Point(0, 0);
                            top_points[1] = new Point(delta_x, delta_y);
                            top_points[2] = new Point(0, 0);
                            top_points[3] = new Point(-delta_x, -delta_y);
                            side_points[0] = new Point(0, 0);
                            side_points[1] = new Point(delta_x, delta_y);
                            side_points[2] = new Point(0, 0);
                            side_points[3] = new Point(-delta_x, -delta_y);
                            if (inverted) {
                                side_points[0].x = bar_width >= 0 ? (delta_x > 0 ? pix_x : pix_org) : (delta_x > 0 ? pix_org : pix_x);
                                int pix_top = switch_order ? pix_y : pix_y - bar_height;
                                top_points[0].x = pix_x - bar_width;
                                top_points[0].y = pix_top;
                                top_points[2].x = bar_width;
                                side_points[0].y = pix_y - bar_height;
                                side_points[2].y = bar_height;
                                bp.top = top_points;
                                bp.side = side_points;
                            } else {
                                int pix_side;
                                top_points[0].y = bar_height >= 0 ? (delta_y <= 0 ? pix_y : pix_org) : (delta_y <= 0 ? pix_org : pix_y);
                                side_points[0].x = pix_side = switch_order ? pix_x : pix_x + bar_width;
                                side_points[0].y = pix_y + bar_height;
                                side_points[2].y = -bar_height;
                                top_points[0].x = pix_x;
                                top_points[2].x = bar_width;
                                bp.top = top_points;
                                bp.side = side_points;
                            }
                        }
                        if (inverted) {
                            pix_x = pix_org;
                            pix_y = this.dataObject.xaxis.toPixel(bp.x);
                            bar_width = this.dataObject.yaxis.toPixel(bp.y) - pix_x;
                            bar_height = pix_y - this.dataObject.xaxis.toPixel(bp.x + this.bar_base);
                            pix_y -= bar_height;
                        }
                        if (bar_width < 0) {
                            bar_width = -bar_width;
                            pix_x -= bar_width;
                        }
                        if (bar_height < 0) {
                            bar_height = -bar_height;
                            pix_y -= bar_height;
                        }
                        bp.front = new Rectangle(pix_x, pix_y, bar_width, bar_height);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void draw(Graphics gc) {
        Point firstLast = this.dataObject.getFirstLast();
        if (firstLast == null) {
            return;
        }
        boolean inverted = this.dataObject.xaxis.isVertical;
        if (this.pts == null) {
            try {
                this.recalc();
                if (this.pts == null) {
                    return;
                }
            }
            catch (Exception exception) {}
        }
        int pix_org = this.dataObject.yaxis.toPixel(this.dataObject.yaxis.origin.value);
        ChartDataViewSeries[] series = this.dataObject.getSeries();
        if (this.is_3d) {
            boolean more_clusters;
            int inc;
            int jbeg;
            int ibeg;
            boolean x_reversed;
            int delta_x = this.chartArea.deltaX;
            int delta_y = this.chartArea.deltaY;
            boolean bl = x_reversed = this.dataObject.xaxis.isReversed;
            boolean switch_order = inverted ? (delta_y > 0 ? true ^ x_reversed : x_reversed) : (delta_x <= 0 ? true ^ x_reversed : x_reversed);
            int first_set = 0;
            int last_set = series.length - 1;
            if (switch_order) {
                ibeg = firstLast.y;
                jbeg = last_set;
                inc = -1;
                more_clusters = ibeg >= firstLast.x;
            } else {
                ibeg = firstLast.x;
                jbeg = first_set;
                inc = 1;
                more_clusters = ibeg <= firstLast.y;
            }
            int i = ibeg;
            while (more_clusters) {
                int position = i - ibeg;
                boolean more_bars = switch_order ? jbeg >= first_set : jbeg <= last_set;
                int j = jbeg;
                while (more_bars) {
                    BarPoint bp = null;
                    try {
                        bp = this.pts[position][j];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (bp != null && bp.x != this.dataObject.holeValue && bp.y != this.dataObject.holeValue && series[j].getStyle().getFillStyle().getImage() == null) {
                        this.draw_3dbar(gc, i, j, bp.top, bp.side, this.drawOutline);
                    }
                    more_bars = switch_order ? j > first_set : j < last_set;
                    j += inc;
                }
                more_clusters = switch_order ? i > firstLast.x : i < firstLast.y;
                i += inc;
            }
        }
        int j = 0;
        while (j < series.length) {
            if (series[j].isShowing) {
                JCChartStyle cs = series[j].getStyle();
                int i = firstLast.x;
                while (i <= firstLast.y) {
                    BarPoint bp = null;
                    int position = i - firstLast.x;
                    try {
                        bp = this.pts[position][j];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (bp != null && bp.x != this.dataObject.holeValue && bp.y != this.dataObject.holeValue) {
                        JCFillStyle fs = cs.getFillStyle();
                        if (series[j].getStyle().getFillStyle().getImage() != null) {
                            fs.fillImageRect(gc, bp.front.x, bp.front.y, bp.front.width, bp.front.height, bp.y >= 0.0, inverted);
                        } else if (this.drawOutline) {
                            fs.fillOutlineRect(gc, bp.front.x, bp.front.y, bp.front.width, bp.front.height, this.chartArea.getForeground());
                        } else {
                            fs.fillRect(gc, bp.front.x, bp.front.y, bp.front.width, bp.front.height);
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    void draw_3dbar(Graphics gc, int i, int j, Point[] top, Point[] side, boolean drawOutline) {
        ChartDataViewSeries[] series = this.dataObject.getSeries();
        JCFillStyle fstyle = series[j].getStyle().getFillStyle();
        int delta_x = this.chartArea.deltaX;
        int delta_y = this.chartArea.deltaY;
        if (top != null) {
            Polygon top_poly = JCChartUtil.pointsToPolygon(top);
            if (delta_y <= 0) {
                if (drawOutline) {
                    fstyle.fillOutlinePolygonHighlight(gc, top_poly, this.chartArea.getForeground());
                } else {
                    fstyle.fillPolygonHighlight(gc, top_poly);
                }
            } else if (drawOutline) {
                fstyle.fillOutlinePolygonShadow(gc, top_poly, this.chartArea.getForeground());
            } else {
                fstyle.fillPolygonShadow(gc, top_poly);
            }
        }
        if (side != null) {
            Polygon side_poly = JCChartUtil.pointsToPolygon(side);
            if (delta_x <= 0) {
                if (drawOutline) {
                    fstyle.fillOutlinePolygonHighlight(gc, side_poly, this.chartArea.getForeground());
                } else {
                    fstyle.fillPolygonHighlight(gc, side_poly);
                }
            } else if (drawOutline) {
                fstyle.fillOutlinePolygonShadow(gc, side_poly, this.chartArea.getForeground());
            } else {
                fstyle.fillPolygonShadow(gc, side_poly);
            }
        }
    }

    JCDataIndex pick(Point pt, int focus) {
        boolean is_3d;
        boolean inverted = this.dataObject.xaxis.isVertical;
        Rectangle r = this.chartArea.getDrawingArea();
        Point p = new Point(pt.x - r.x, pt.y - r.y);
        int series = -1;
        int point = -1;
        JCDataIndex di = null;
        int length = Integer.MAX_VALUE;
        ChartDataViewSeries[] seriesList = this.dataObject.getSeries();
        Point firstLast = this.dataObject.getFirstLast();
        if (firstLast == null || this.pts == null) {
            return null;
        }
        int delta_x = this.chartArea.deltaX;
        int delta_y = this.chartArea.deltaY;
        boolean bl = is_3d = delta_x != 0 || delta_y != 0;
        if (is_3d) {
            boolean more_clusters;
            int inc;
            int jbeg;
            int ibeg;
            boolean x_reversed;
            boolean bl2 = x_reversed = this.dataObject.xaxis.isReversed;
            boolean switch_order = inverted ? (delta_y > 0 ? true ^ x_reversed : x_reversed) : (delta_x <= 0 ? true ^ x_reversed : x_reversed);
            int first_set = 0;
            int last_set = seriesList.length - 1;
            if (switch_order) {
                ibeg = firstLast.y;
                jbeg = last_set;
                inc = -1;
                more_clusters = ibeg >= firstLast.x;
            } else {
                ibeg = firstLast.x;
                jbeg = first_set;
                inc = 1;
                more_clusters = ibeg <= firstLast.y;
            }
            int i = ibeg;
            while (more_clusters) {
                int position = i - ibeg;
                boolean more_bars = switch_order ? jbeg >= first_set : jbeg <= last_set;
                int j = jbeg;
                while (more_bars) {
                    BarPoint bp = null;
                    try {
                        bp = this.pts[position][j];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (bp != null) {
                        int len_top = JCChartUtil.distanceTo3dPolygon(p.x, p.y, bp.top, inverted, focus);
                        int len_side = JCChartUtil.distanceTo3dPolygon(p.x, p.y, bp.side, inverted, focus);
                        if (len_top <= length || len_side <= length) {
                            series = j;
                            point = i;
                            length = Math.min(len_side, len_top);
                        }
                    }
                    more_bars = switch_order ? j > first_set : j < last_set;
                    j += inc;
                }
                more_clusters = switch_order ? i > firstLast.x : i < firstLast.y;
                i += inc;
            }
        }
        int i = 0;
        while (i < this.pts.length) {
            if (this.pts[i] != null) {
                int j = 0;
                while (j < this.pts[i].length) {
                    if (seriesList[j].isShowing) {
                        BarPoint bp = null;
                        try {
                            bp = this.pts[i][j];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (bp != null && bp.x != this.dataObject.holeValue && bp.y != this.dataObject.holeValue) {
                            int len = 0;
                            if (bp.front != null && (len = JCChartUtil.distanceToFrontRect(p.x, p.y, bp.front.x, bp.front.y, bp.front.width, bp.front.height, inverted, focus)) <= length) {
                                series = j;
                                point = i;
                                length = len;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (series >= 0 && point >= 0) {
            di = new JCDataIndex(point, seriesList[series], series);
            di.distance = length;
        }
        return di;
    }

    Point unpick(int pt, int seriesIndex) {
        boolean inverted = this.dataObject.xaxis.isVertical;
        BarPoint bp = null;
        try {
            bp = this.pts[pt][seriesIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (bp == null) {
            return null;
        }
        double yvalue = bp.y;
        double xvalue = bp.x;
        int point_x = -1;
        int point_y = -1;
        if (yvalue != this.dataObject.holeValue && xvalue != this.dataObject.holeValue) {
            if (inverted) {
                point_x = this.dataObject.yaxis.toPixel(yvalue);
                point_y = bp.front.y + bp.front.height / 2;
            } else {
                point_y = this.dataObject.yaxis.toPixel(yvalue);
                point_x = bp.front.x + bp.front.width / 2;
            }
            return new Point(point_x, point_y);
        }
        return null;
    }

    void startEdit(JCDataIndex di) {
        this.r = this.chartArea.getDrawingArea();
        this.inverted = di.dataView.xaxis.isVertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex di, int x, int y) {
        if (di == null || di.dataView != this.dataObject) {
            return;
        }
        BarPoint bp = null;
        try {
            bp = this.pts[di.point][di.series.drawingOrder];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (bp == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.inverted) {
            this.start.x = x;
            this.start.y = bp.front.y + this.r.y;
            this.end.x = bp.front.x + this.r.x;
            this.end.y = bp.front.y + this.r.y + bp.front.height;
        } else {
            this.start.x = bp.front.x + this.r.x;
            this.start.y = y;
            this.end.x = bp.front.x + this.r.x + bp.front.width;
            this.end.y = bp.front.height + bp.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    int endEdit(JCDataIndex di, int x, int y) {
        if (di == null || di.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        int off = this.inverted ? x - this.r.x : y - this.r.y;
        return off;
    }
}

